#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.VAL.UnitTests
{
	[TestFixture]
	public class VAL_MedicationProfile : BaseTest 
	{
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			VistALinkUnitTestHarness.RequireConnection();
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection(); 
		}

		[Test]
		public void GetMedicationProfile_Pass()
		{
			int _id = 266763;
			Assert.IsTrue( DAL.VAL.MedicationProfile.GetMedicationProfile( _id, DateTime.Now.Subtract( System.TimeSpan.FromDays( 180 ) ), DateTime.Now ).Tables[0].Rows.Count > 0 );
		}

		[Test]
		public void GetMedicationProfile_Pass2()
		{
			int _id = 266763;
			Assert.IsTrue( DAL.VAL.MedicationProfile.GetMedicationProfile( _id, DateTime.MinValue, DateTime.MinValue ).Tables[0].Rows.Count > 0 );
		}

		[Test]
		public void GetMedicationProfile_Pass3()
		{
			int _id = 1111111;
			Assert.IsTrue( DAL.VAL.MedicationProfile.GetMedicationProfile( _id, DateTime.Now.Subtract( System.TimeSpan.FromDays( 365 ) ), DateTime.Now ).Tables[0].Rows.Count > 0 );
		}

		[Test]
		[ExpectedException( typeof(ArgumentOutOfRangeException) )]
		public void GetMedicationProfile_Fail()
		{
			DAL.VAL.MedicationProfile.GetMedicationProfile(int.MinValue, DateTime.Now.Subtract( System.TimeSpan.FromDays( 365 ) ), DateTime.Now );
		}
	}
}
#endif
